c	torqsubs.for		utility routines.


c--------------------------------------------------------------------------
	integer function ksecmid(hhmmss)
c	converts hhmmss to sections past midnight
	implicit integer (a-z)
	hh = hhmmss/10000
	mm = mod(hhmmss,10000)/100
	ss = mod(hhmmss,100)
	ksecmid = hh*3600 + mm*60 + ss
	return
	end
c--------------------------------------------------------------------------
	integer function khhmmss(ksec)
c	converts seconds past midnight into hhmmss integer variable.
	implicit integer (a-z)
	hh = ksec/3600
	mm = mod(ksec,3600)/60
	ss = mod(ksec,60)
	khhmmss= 10000*hh + 100*mm + ss
	return
	end
c--------------------------------------------------------------------------
	character*8 function chhmmss(ksec)
c	converts seconds past midnight into hh:mm:ss character variable.
	implicit integer (a-z)
	hh = ksec/3600
	mm = mod(ksec,3600)/60
	ss = mod(ksec,60)
	write(chhmmss,100) hh,mm,ss
100	format(i2,':',i2.2,':',i2.2)
	return
	end
c--------------------------------------------------------------------------
	character*8 function cyymmdd(yymmdd)
c	converts seconds past midnight into yy/mm/dd character variable.
	implicit integer (a-z)
	yy = yymmdd/10000
	mm = mod(yymmdd,10000)/100
	dd = mod(yymmdd,100)
	write(cyymmdd,100) yy,mm,dd
100	format(i2,'/',i2.2,'/',i2.2)
	return
	end
c--------------------------------------------------------------------------
	character*20 function upper(s)
c	convert string to upper case
	implicit integer (a-z)
	character*(*) s
	upper = s
	n = len_trim(s)
	if (n.le.0) goto 99
	do 10 i=1,n
	k = ichar(s(i:i))
	if (97.le.k .and. k.le.122) k = k-32
	upper(i:i) = char(k)
10	continue
99	return
	end
c--------------------------------------------------------------------------
	subroutine tfilopen
	include 'torqfils.cmb'
	character*30 fname,fsymdat,fcq,fct,fsod,fcd

	open (unit=1,file='torqfils.ini',status='old',err=50)
	read(1,100) fname,fsymdat,fcq,fct,fsod,fcd
100	format(a30)
	close (unit=1)

c	input files:
	krnm = 1
	open (unit=krnm,file=fname,
     $	access='sequential',status='old',share='denywr',err=51)
	krmap = 2
	open (unit=krmap,file=fsymdat,recl=55,err=52,
     $	access='direct',form='unformatted',status='old',share='denywr')
	krct = 3
	open (unit=krct,file=fct,recl=31,err=53,
     $	access='direct',form='unformatted',status='old',share='denywr')
	krcq = 4
	open (unit=krcq,file=fcq,recl=31,err=54,
     $	access='direct',form='unformatted',status='old',share='denywr')
	krcd = 5
	open (unit=krcd,file=fcd,recl=59,err=55,
     $	access='direct',form='unformatted',status='old',share='denywr')
	krsod = 6
	open (unit=krsod,file=fsod,recl=119,err=56,
     $	access='direct',form='unformatted',status='old',share='denywr')
	go to 99

50	write(*,*) " Error. Can't find torqfils.ini in current directory."
	stop
51	write(*,*) " Error. Can't find file: ",fname
	write(*,*) " Check your torqfils.ini file."
	stop
52	write(*,*) " Error. Can't find file: ",fsymdat
	write(*,*) " Check your torqfils.ini file."
	stop
53	write(*,*) " Error. Can't find file: ",fct
	write(*,*) " Check your torqfils.ini file."
	stop
54	write(*,*) " Error. Can't find file: ",fcq
	write(*,*) " Check your torqfils.ini file."
	stop
55	write(*,*) " Error. Can't find file: ",fcd
	write(*,*) " Check your torqfils.ini file."
	stop
56	write(*,*) " Error. Can't find file: ",fsod
	write(*,*) " Check your torqfils.ini file."
	stop
99	return
	end
